//
//  Material.vsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//


#ifdef OGL_ES2

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define prec_high highp
#define prec_med mediump
#define prec_low lowp

#else 

#define prec_high
#define prec_med 
#define prec_low 

#endif

attribute vec4 a_position;
attribute prec_med vec2 a_texture0_coords;
varying prec_med vec2 v_texture0_coord;

uniform prec_high mat4 u_modelViewProjectionMatrix;
 
uniform prec_med float u_originalTextureSize;
uniform prec_med float u_mipmapTextureSize;

float ShiftRight(float value, int count)
{
	for (int i=0; i<count; i++)
	{
		value = value / 2.0;
	}
	
	return value;
}

void main()
{ 
	gl_Position = u_modelViewProjectionMatrix * a_position;
 
	// NOTE: why the shift? That’s because we don’t want the largest mip level to indicate “ideal texel to pixel” density.
	// We also want a way to visualize “not enough texel density”. So we push the ideal mip level two levels down, 
	// which means it’s four times UV difference.
	v_texture0_coord = a_texture0_coords * (u_originalTextureSize / ShiftRight(u_mipmapTextureSize, 2));

}

